//
//  $Id: AHKPerson.h 98 2009-06-12 17:01:44Z fujidana $
//  Copyright (c) 2005-2009 Fujidana All rights reserved.
//


#import <Foundation/Foundation.h>
#import "AHKNumbering.h"


@class AHKPhoneNumbers;
@class AHKEmailAddresses;
@class ABPerson;

typedef enum {
	AHKHomeAddressType = 0,
	AHKWorkAddressType,
	AHKOtherAddressType
} AHKAddressType;

typedef enum {
	AHKABloodType = 0,
	AHKBBloodType,
	AHKABBloodType,
	AHKOBloodType,
	AHKUnclassifiedBloodType
} AHKBloodType;

typedef enum {
	AHKAriesConstellation = 0,
	AHKTaurusConstellation,
	AHKGeminiConstellation,
	AHKCancerConstellation,
	AHKLeoConstellation,
	AHKVirgoConstellation,
	AHKLibraConstellation,
	AHKScorpioConstellation,
	AHKOphiuchusConstellation,
	AHKSagittariusConstellation,
	AHKCapricornConstellation,
	AHKAquariusConstellation,
	AHKPiscesConstellation,
	AHKUnclassifiedConstellation
} AHKConstellation;

typedef enum {
	AHKDerivingSignsOfZodiacNo = 0,
	AHKDerivingSignsOfZodiacFrom12Constellation = 12,
	AHKDerivingSignsOfZodiacFrom13Constellation = 13
} AHKDerivingSignsOfZodiacOption;

typedef enum {
	AHKKyoponVCardFormat = 0,
	AHKAddressBookVCardFormat = 1,
} AHKVCardFormat;


@interface AHKPerson : NSObject <NSCoding, AHKNumbering>
{
	int               number;
	int               groupNumber;
	NSString          *name;
	NSString          *phoneticName;
	
	AHKPhoneNumbers   *phones;
	AHKEmailAddresses *emails;
	
	int               addressLabel;
	NSString          *addressValue;
	
	NSString          *url;
	int               bloodType;
	int               zodiac;
	NSCalendarDate    *birthday;
	NSString          *hobby;
	NSString          *note;
	BOOL              secured;
}

+ (int)derivingSignsOfZodiacOption;
+ (void)setDerivingSignsOfZodiacOption:(int)value;
+ (int)maximumNumber;
+ (void)setMaximumNumber:(int)value;

- (int)number;
- (void)setNumber:(int)value;
- (BOOL)validateNumber:(id *)ioValue error:(NSError **)outError;

- (int)groupNumber;
- (void)setGroupNumber:(int)value;
- (BOOL)validateGroupNumber:(id *)ioValue error:(NSError **)outError;

- (NSString *)name;
- (void)setName:(NSString *)value;
- (BOOL)validateName:(id *)ioValue error:(NSError **)outError;

- (NSString *)phoneticName;
- (void)setPhoneticName:(NSString *)value;
- (BOOL)validatePhoneticName:(id *)ioValue error:(NSError **)outError;

- (AHKPhoneNumbers *)phones;
- (void)setPhones:(AHKPhoneNumbers *)value;

- (AHKEmailAddresses *)emails;
- (void)setEmails:(AHKEmailAddresses *)value;

- (AHKAddressType)addressLabel;
- (void)setAddressLabel:(AHKAddressType)value;

- (NSString *)addressValue;
- (void)setAddressValue:(NSString *)value;
- (BOOL)validateAddressValue:(id *)ioValue error:(NSError **)outError;

- (NSString *)url;
- (void)setUrl:(NSString *)value;
- (BOOL)validateUrl:(id *)ioValue error:(NSError **)outError;

- (AHKBloodType)bloodType;
- (void)setBloodType:(AHKBloodType)value;
- (BOOL)validateBloodType:(id *)ioValue error:(NSError **)outError;

- (AHKConstellation)zodiac;
- (void)setZodiac:(AHKConstellation)value;
- (BOOL)validateZodiac:(id *)ioValue error:(NSError **)outError;

- (NSCalendarDate *)birthday;
- (void)setBirthday:(NSCalendarDate *)value;
- (BOOL)validateBirthday:(id *)ioValue error:(NSError **)outError;

- (NSString *)hobby;
- (void)setHobby:(NSString *)value;
- (BOOL)validateHobby:(id *)ioValue error:(NSError **)outError;

- (NSString *)note;
- (void)setNote:(NSString *)value;
- (BOOL)validateNote:(id *)ioValue error:(NSError **)outError;

- (BOOL)isSecured;
- (void)setSecured:(BOOL)flag;

- (NSString *)addressLabelString;
- (void)setAddressLabelString:(NSString *)value;

- (NSString *)bloodTypeString;
- (void)setBloodTypeString:(NSString *)value;

- (NSString *)zodiacString;
- (void)setZodiacString:(NSString *)value;

- (NSString *)tabSeparatedValues;
+ (NSString *)tabSeparatedValuesHeader;

@end


@interface AHKPerson (VCard)

+ (NSArray *)peopleWithVCardRepresentation:(NSData *)data;
+ (NSData *)vCardRepresentationOfPeople:(NSArray *)people format:(AHKVCardFormat)format;

- (id)initWithABPerson:(ABPerson *)person;
- (id)initWithVCardRepresentation:(NSData *)vCardData;
- (id)initWithVCardRepresentation:(NSData *)vCardData format:(AHKVCardFormat)format;

- (NSData *)vCardRepresentation;
- (NSData *)vCardRepresentationWithFormat:(AHKVCardFormat)format;

@end
